# 通知設計書 9-Download was canceled or failed.

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるダウンロードキャンセル/失敗通知「Download was canceled or failed.」の設計仕様を定義する。この通知は、ToolUpdate機能でファイルのダウンロードがキャンセルまたは失敗した際に表示される情報通知である。

### 本通知の処理概要

「Download was canceled or failed.」通知は、ツール更新プロセスにおいてダウンロードが正常に完了しなかったことをユーザーに伝達するための通知メカニズムである。

**業務上の目的・背景**：ツールの更新プロセスにおいて、ダウンロードフェーズがユーザーのキャンセルまたは何らかのエラーにより中断されたことをフィードバックする。StaxRipUpdateの「Download failed!」とは異なり、ToolUpdate固有の文脈で使用され、キャンセルと失敗の両方を包含するメッセージとなっている。ダウンロードフォーム（DownloadForm）での操作結果に基づいて表示される。

**通知の送信タイミング**：DownloadFormのShowDialog()がDialogResult.OK以外を返した場合、または期待されたファイルが存在しない場合に表示される。

**通知の受信者**：ツールの更新を実行しているユーザー。

**通知内容の概要**：「Download was canceled or failed.」という情報メッセージがMsgInfo形式で表示される。Infoアイコン（青い情報マーク）とOKボタンが配置される。

**期待されるアクション**：ユーザーはダウンロードがキャンセルまたは失敗したことを確認し、OKボタンをクリックしてダイアログを閉じる。必要に応じて、再度ダウンロードを試みるか、手動でツールをインストールする。

## 通知種別

アプリ内通知（タスクダイアログ/MsgInfo）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

ToolUpdate.Download()メソッド内でDownloadFormの結果に基づいて表示される。フォームを閉じた後に同期的に表示。

## 通知テンプレート

### メール通知の場合

該当なし（アプリ内通知のため）

### 本文テンプレート

```
[タイトル]
Download was canceled or failed.

[コンテンツ]
（なし）

[アイコン]
Info（青い情報アイコン）

[ボタン]
OK
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | DownloadForm.ShowDialog() | DialogResult <> OK または ファイル不存在 | ダウンロードダイアログが成功以外で閉じられた場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| DialogResult = OK かつ DownloadFile.FileExists | ダウンロードが成功してファイルが存在する場合は表示しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ToolUpdate.Download開始] --> B[MessageBox確認ダイアログ]
    B --> C{ユーザー選択}
    C -->|Cancel| D[処理終了]
    C -->|OK| E[DownloadForm表示]
    E --> F[ダウンロード処理]
    F --> G{ShowDialog結果}
    G -->|OK| H{DownloadFile.FileExists?}
    G -->|Cancel/その他| I[FileHelp.Delete/ダウンロードファイル削除]
    H -->|Yes| J[Extract処理へ]
    H -->|No| K[MsgError Downloaded file is missing.]
    I --> L[MsgInfo Download was canceled or failed.]
    L --> M[ダイアログ表示]
    M --> N{ユーザー操作}
    N -->|OK| O[ダイアログクローズ]
    O --> P[終了]
    J --> Q[抽出処理]
    K --> P
    D --> P
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

該当なし

#### 送信ログテーブル

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ユーザーキャンセル | DownloadFormでキャンセル操作 | MsgInfoで通知、一時ファイル削除 |
| ダウンロード失敗 | ネットワークエラー等で失敗 | MsgInfoで通知、一時ファイル削除 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ダウンロード失敗時は一時ファイルが削除される（FileHelp.Delete）
- 不完全なファイルが残らないよう配慮されている

## 備考

- ToolUpdate.Download()内で使用される
- StaxRipUpdateの「Download failed!」（MsgError）とは異なり、MsgInfo形式で表示される
- キャンセルと失敗を区別せず、同一メッセージで通知

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ToolUpdateクラスの構造とDownloadFileプロパティを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ToolUpdate.vb | `Source/General/ToolUpdate.vb` | DownloadFileプロパティ（行10）、Packageプロパティ |

**読解のコツ**: DownloadFileはダウンロード先のファイルパスを保持し、ダウンロード成功/失敗の判定に使用される。

#### Step 2: エントリーポイントを理解する

Download()メソッドの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ToolUpdate.vb | `Source/General/ToolUpdate.vb` | Download関数の定義（行47-66） |

**主要処理フロー**:
1. **行47**: Sub Download(url As String)
2. **行49**: MessageBox.Show でダウンロード確認
3. **行53**: Using form As New DownloadForm(url, DownloadFile)
4. **行54**: If form.ShowDialog() = DialogResult.OK AndAlso DownloadFile.FileExists
5. **行55-58**: 成功時は条件分岐（ファイル存在確認）
6. **行60-62**: Else節 - 失敗/キャンセル時の処理
7. **行61**: FileHelp.Delete(DownloadFile) - 一時ファイル削除
8. **行62**: MsgInfo("Download was canceled or failed.")

#### Step 3: DownloadFormの動作を理解する

DownloadFormがどのようにダウンロードを処理し、DialogResultを返すかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DownloadForm.vb | `Source/Forms/DownloadForm.vb` | フォームの構造、ShowDialogの結果がどう決まるか |

**主要処理フロー**:
- ダウンロード完了時: DialogResult.OK
- キャンセル時: DialogResult.Cancel

### プログラム呼び出し階層図

```
ToolUpdate.Update()  [ToolUpdate.vb:24]
    |
    +-- ToolUpdate.Download(url)  [ToolUpdate.vb:47]
           |
           +-- MessageBox.Show() - 確認ダイアログ
           |
           +-- (OK選択時)
                  |
                  +-- Using New DownloadForm(url, DownloadFile)
                         |
                         +-- form.ShowDialog()  [DownloadForm.vb]
                                |
                                +-- [ダウンロード処理]
                                       |
                         +── (DialogResult = OK かつ FileExists)
                         |      |
                         |      +-- Extract()  [ToolUpdate.vb:68]
                         |
                         +── (DialogResult <> OK または Not FileExists)
                                |
                                +-- FileHelp.Delete(DownloadFile)
                                |
                                +-- MsgInfo("Download was canceled or failed.")
                                       |
                                       +-- MsgInfo()  [General.vb:1216]
```

### データフロー図

```
[入力]               [処理]                    [出力]

Download URL ──────> DownloadForm表示 ───────> ダウンロード開始
                           |
                     [非同期ダウンロード]
                           |
                     ShowDialog()結果 ───────> DialogResult
                           |
                     ┌─────┴─────┐
                     ↓           ↓
                    OK      Cancel/その他
                     |           |
             FileExists? ───> FileHelp.Delete()
                     |           |
              ┌──────┴──────┐    |
              ↓             ↓    |
             Yes           No    |
              |             |    |
         Extract()    MsgError   MsgInfo表示
                           |         |
                           |   "Download was
                           |   canceled or failed."
                           |         |
                           +────> [終了]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ToolUpdate.vb | `Source/General/ToolUpdate.vb` | ソース | Download関数、通知発生元 |
| DownloadForm.vb | `Source/Forms/DownloadForm.vb` | ソース | ダウンロード進捗表示フォーム |
| General.vb | `Source/General/General.vb` | ソース | MsgInfo関数の定義 |
| FileHelp | 不明（拡張メソッド） | ソース | Delete関数でのファイル削除 |
